/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum ApplicationEdition {
    NG("PaperCutNG"),
    ChargeBack("PaperCutChargeBack"),
    MF("PaperCutMF"),
    Any("PaperCutExtension");

    private String _defaultLicensePrefix;

    private ApplicationEdition(String defaultLicensePrefix) {
        this._defaultLicensePrefix = defaultLicensePrefix;
    }

    public String getDefaultLicensePrefix() {
        return this._defaultLicensePrefix;
    }

    public void setDefaultLicensePrefix(String defaultLicensePrefix) {
        this._defaultLicensePrefix = defaultLicensePrefix;
    }

    public static ApplicationEdition fromStringValues(String value) {
        Map<String, String> availableEditions = Arrays.stream(value.split(",")).map(String::toLowerCase).collect(Collectors.toMap(v -> v, v -> v));
        if (availableEditions.containsKey(MF.toString().toLowerCase())) {
            return MF;
        }
        if (availableEditions.containsKey(ChargeBack.toString().toLowerCase())) {
            return ChargeBack;
        }
        if (availableEditions.containsKey(NG.toString().toLowerCase())) {
            return NG;
        }
        if (availableEditions.containsKey(Any.toString().toLowerCase())) {
            return Any;
        }
        throw new IllegalStateException("Application edition is not recognised");
    }
}

