/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.ProcessUtils;
import biz.papercut.pcng.util.io.StringBufferLineHandler;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformInfo {
    private static final Logger logger = LoggerFactory.getLogger(PlatformInfo.class);
    private static final String WINDOWS_NT_UNKNOWN_OS_NAME = "Windows NT (unknown)";
    private static final Set<String> ARCH_64_NAMES = ImmutableSet.of((Object)"amd64", (Object)"x86_64");
    private static final String ARCH_64_CANONICAL = "amd64";
    private final String _osName;
    private final String _osVersion;
    private final String _osPatchLevel;
    private final String _osArch;
    private final String _jvmVersion;
    private final String _jvmArch;
    @Nullable
    private static PlatformInfo _instance;

    public static synchronized PlatformInfo getPlatformInfo() {
        String linuxDistro;
        String jvmArch;
        if (_instance != null) {
            return _instance;
        }
        String osName = StringUtils.trimToEmpty((String)System.getProperty("os.name"));
        String osVersion = StringUtils.trimToEmpty((String)System.getProperty("os.version"));
        String osPatchLevel = StringUtils.trimToEmpty((String)System.getProperty("sun.os.patch.level"));
        String osArch = jvmArch = StringUtils.trimToEmpty((String)System.getProperty("os.arch")).toLowerCase();
        String jvmVersion = StringUtils.trimToEmpty((String)System.getProperty("java.runtime.version"));
        if (SystemUtils.IS_OS_LINUX && StringUtils.isNotBlank((String)(linuxDistro = PlatformInfo.getLinuxDistroDescription()))) {
            osVersion = linuxDistro;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            Optional<String> windowsName;
            String procArch = StringUtils.trimToEmpty((String)System.getenv("PROCESSOR_ARCHITECTURE")).toLowerCase();
            String procWOWArch = StringUtils.trimToEmpty((String)System.getenv("PROCESSOR_ARCHITEW6432")).toLowerCase();
            if (ARCH_64_NAMES.contains(jvmArch) || ARCH_64_NAMES.contains(procArch) || ARCH_64_NAMES.contains(procWOWArch)) {
                osArch = ARCH_64_CANONICAL;
            }
            if (WINDOWS_NT_UNKNOWN_OS_NAME.equals(osName) && (windowsName = PlatformInfo.getUnknownWindowsName()).isPresent()) {
                osName = windowsName.get();
            }
        }
        _instance = new PlatformInfo(osName, osVersion, osPatchLevel, osArch, jvmVersion, jvmArch);
        return _instance;
    }

    private static Optional<String> getUnknownWindowsName() {
        StringBufferLineHandler errorHandler = new StringBufferLineHandler();
        StringBufferLineHandler stdoutHandler = new StringBufferLineHandler();
        try {
            String osName;
            int exitCode = ProcessUtils.exec(new String[]{"wmic", "os", "get", "Caption", "/value"}, new ProcessUtils.LineStreamHandler(null, stdoutHandler, errorHandler, StandardCharsets.UTF_8));
            String output = stdoutHandler.getStringBuffer().toString().trim();
            if (exitCode == 0 && StringUtils.isNotBlank((String)(osName = StringUtils.substringAfter((String)output, (String)"Caption=")))) {
                return Optional.of(osName);
            }
            logger.warn("Unable to determine windows version. Output: {}, Error: {}", (Object)output, (Object)errorHandler.getStringBuffer().toString());
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            logger.warn("Unable to determine windows version", (Throwable)e);
        }
        return Optional.empty();
    }

    @Nullable
    private static String getLinuxDistroDescription() {
        return PlatformInfo.getLinuxDistroDescription(new File("/etc/"));
    }

    @Nullable
    private static String getLinuxDistroDescription(File etcDir) {
        try {
            StringBufferLineHandler errorHandler = new StringBufferLineHandler();
            StringBufferLineHandler stdoutHandler = new StringBufferLineHandler();
            int exitCode = ProcessUtils.exec(new String[]{"lsb_release", "-sd"}, new ProcessUtils.LineStreamHandler(null, stdoutHandler, errorHandler, StandardCharsets.UTF_8));
            if (exitCode == 0 && stdoutHandler.getStringBuffer().toString().length() > 0) {
                return stdoutHandler.getStringBuffer().toString().trim();
            }
        }
        catch (Exception e) {
            logger.debug("Cannot get Linux version from lsb_release: {}", (Object)e.getMessage());
        }
        File osReleaseFile = new File(etcDir, "os-release");
        if (osReleaseFile.exists()) {
            try {
                List lines = Files.readLines((File)osReleaseFile, (Charset)Charsets.UTF_8);
                Pattern re = Pattern.compile("PRETTY_NAME=\"(.*)\"");
                for (String line : lines) {
                    Matcher m = re.matcher(line);
                    if (!m.find()) continue;
                    return m.group(1).trim();
                }
            }
            catch (Exception e) {
                logger.debug("Unable to get Linux version from os-release: {}", (Object)e.getMessage());
            }
        }
        for (String fn : new String[]{"system-release", "redhat-release", "SuSE-release"}) {
            File file = new File(etcDir, fn);
            if (!file.exists()) continue;
            try {
                String firstLine = Files.asCharSource((File)file, (Charset)Charsets.UTF_8).readFirstLine();
                if (!StringUtils.isNotBlank((String)firstLine)) continue;
                return firstLine.trim();
            }
            catch (IOException e) {
                logger.debug("Unable to read Linux distro version from file: {}", (Object)file, (Object)e);
            }
        }
        File debianVersionFile = new File(etcDir, "debian_version");
        if (debianVersionFile.exists()) {
            try {
                String firstLine = Files.asCharSource((File)debianVersionFile, (Charset)Charsets.UTF_8).readFirstLine();
                if (StringUtils.isNotBlank((String)firstLine)) {
                    return "Debian " + firstLine.trim();
                }
            }
            catch (IOException e) {
                logger.debug("Unable to read Linux distro version from file: {}", (Object)debianVersionFile, (Object)e);
            }
        }
        return null;
    }

    private PlatformInfo(String osName, String osVersion, String osPatchLevel, String osArch, String jvmVersion, String jvmArch) {
        this._osName = osName;
        this._osVersion = osVersion;
        this._osPatchLevel = osPatchLevel;
        this._osArch = osArch;
        this._jvmVersion = jvmVersion;
        this._jvmArch = jvmArch;
    }

    public String getOSName() {
        return this._osName;
    }

    public String getOSVersion() {
        return this._osVersion;
    }

    public String getOSPatchLevel() {
        return this._osPatchLevel;
    }

    public String getOSArch() {
        return this._osArch;
    }

    public boolean isOS64Bit() {
        return ARCH_64_NAMES.contains(this._osArch);
    }

    public String getJVMVersion() {
        return this._jvmVersion;
    }

    public String getJVMArch() {
        return this._jvmArch;
    }

    public boolean isJVM64Bit() {
        return ARCH_64_NAMES.contains(this._jvmArch);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._osName);
        sb.append(" - ");
        sb.append(this._osVersion);
        if (StringUtils.isNotBlank((String)this._osPatchLevel)) {
            sb.append(" (").append(this._osPatchLevel).append(")");
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            sb.append(" ");
            sb.append(this.isOS64Bit() ? "64-bit" : "32-bit");
        }
        sb.append(" [runtime: ");
        sb.append(this._jvmVersion);
        sb.append(" (");
        sb.append(this._jvmArch);
        sb.append(")]");
        return sb.toString();
    }
}

